/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier;

import com.hoshino.cti.Cti;
import com.hoshino.cti.Entity.Projectiles.StarDargonAmmo;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class StarDragonHit
extends Modifier
implements MeleeHitModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook,
ProjectileHitModifierHook,
InventoryTickModifierHook {
    public static final ResourceLocation STAR_DUST = Cti.getResource("star_dust");
    public static final ResourceLocation STAR_FREEZE_TICK = Cti.getResource("star_freeze");
    public static final Map<UUID, Float> DAMAGE_SHOULD_BE = new ConcurrentHashMap<UUID, Float>();

    public int getPriority() {
        return 10;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.MELEE_HIT, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP, ModifierHooks.PROJECTILE_HIT, ModifierHooks.INVENTORY_TICK});
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player = context.getPlayerAttacker();
        LivingEntity target = context.getLivingTarget();
        if (player == null || target == null) {
            return;
        }
        if (target.m_21223_() / target.m_21233_() < 0.18f) {
            if (target instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)target;
                enderDragon.m_6469_(DamageSource.m_19344_((Player)player).m_19380_().m_19382_(), 2.1474836E9f);
                return;
            }
            target.m_6667_(DamageSource.m_19344_((Player)player));
            target.m_146870_();
            tool.getPersistentData().putInt(STAR_DUST, tool.getPersistentData().getInt(STAR_DUST) + 1);
            player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_11890_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player != null) {
            DAMAGE_SHOULD_BE.put(player.m_20148_(), Float.valueOf(damage + 500.0f));
        }
        return damage + (float)(1000 * modifier.getLevel());
    }

    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237113_((String)("\u5f53\u524d\u661f\u5c18\u6570\u91cf" + this.getDustAmount(iToolStackView))).m_130938_(style -> style.m_178520_(3687935)));
    }

    private int getDustAmount(IToolStackView view) {
        return view.getPersistentData().getInt(STAR_DUST);
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (target != null && persistentData.getInt(STAR_DUST) > 10) {
                persistentData.putInt(STAR_DUST, persistentData.getInt(STAR_DUST) - 10);
                float damageShouldBe = DAMAGE_SHOULD_BE.getOrDefault(player.m_20148_(), Float.valueOf(10.0f)).floatValue();
                StarDargonAmmo ammo = new StarDargonAmmo((LivingEntity)player, player.m_9236_(), target.m_20183_(), damageShouldBe, Math.min(0.21f + (float)persistentData.getInt(STAR_DUST) / 100.0f * 0.01f, 0.78f));
                player.m_9236_().m_7967_((Entity)ammo);
            }
        }
        return false;
    }

    public static int getFreezeTick(IToolStackView view) {
        return view.getPersistentData().getInt(STAR_FREEZE_TICK);
    }

    public static void setFreezeTick(IToolStackView view, int tick) {
        view.getPersistentData().putInt(STAR_FREEZE_TICK, tick);
    }

    public void onInventoryTick(IToolStackView iToolStackView, ModifierEntry modifierEntry, Level level, LivingEntity livingEntity, int i, boolean b, boolean b1, ItemStack itemStack) {
        if (livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        if (StarDragonHit.getFreezeTick(iToolStackView) > 0) {
            StarDragonHit.setFreezeTick(iToolStackView, StarDragonHit.getFreezeTick(iToolStackView) - 1);
        }
    }
}

